#!/usr/bin/env python
import pika
import time
import websocket, base64
import simplejson as json
import os
import sys
import logging_rpi
import subprocess
from datetime import datetime
import BackhaulConfiguration

# WEBSOCKETWORKERCB - same like socketworkerCB but to go websocket instead
# For any data, it will go through customCallback and retry data sending at most 3 times before sleeping
# Data must be acknowledged with ack or reject -- otherwise the data is never discarded

# If backhaul enables direct reply, customCallback will requeue the server's response back to an imaginary queue

# Credits to Tymm lmao

class SocketWorkerCB(object):

	def __init__(self, configuration):

		# Backhaul Configuration
		#BackhaulConfiguration.generateConfigurationFile()
		
		self.configuration = configuration
		self.header = self.getHeader(self.configuration["wsUser"], self.configuration["wsPassword"])
		self.channel = None
		self.connection = None

		# SocketCB Variables
		self.publicQueue = 'websocketQueue'
		self.socketErrors = ['10053', 'Broken pipe', 'Connection is already closed', 'Connection timed out']
		self.lastUpdated = datetime.now()

		# Websocket Type
		if self.configuration["SendType"] in ["Websocket", "Both"]:
			self.wsReaderConn = self.createConnection()
		else:
			print "Not Requested to Send Data!"
			raise Exception("NotEnabled")

	def createConnection(self):
		print "Creating connection to ... " + str(self.configuration["WebsocketURL"])
		if self.configuration["BasicAuth"]:
			return websocket.create_connection(self.configuration["WebsocketURL"], header=self.header, timeout=60)
		else:
			return websocket.create_connection(self.configuration["WebsocketURL"], timeout=60)

	def getHeader(self, username, password):
		user = str(username)
		password = str(password)
		token = base64.b64encode(user + ":" + password)
		header = {}
		header["Authorization"] = "Basic "+ token
		return header

	def reconnectSocket(self, topic):
		# Connections can drop from inactivity, leading to broken pipe or so. 
		# Reconnect by creating the connection again
		try:
			self.wsReaderConn.close()
		except Exception as e:
			logging_rpi.log.info("WebsocketWorkerCB:::Reconnect Socket:::For " + topic + " has already been closed")

		self.configuration = BackhaulConfiguration.getDeviceConfig()
                self.wsReaderConn = self.createConnection()

	def customCallback(self, ch, method, properties, body, retries):

		if retries < 0:
			return False

		try:
			print(" - - - - - - - - - - - - - ")

			data = json.loads(body)
			directReply = False
			
			#########################################
			# UPDATE BACKHAUL
			#########################################

			currentTime = datetime.now()
			difference =  (currentTime - self.lastUpdated).seconds
			if difference >= self.configuration['UpdateInterval']:
				print("Interval hit. Updating configuration...")
				self.configuration = BackhaulConfiguration.getDeviceConfig()
				self.header = self.getHeader(self.configuration["wsUser"], self.configuration["wsPassword"])
				self.lastUpdated = currentTime
				BackhaulConfiguration.writeBackup()
				BackhaulConfiguration.logProcess(os.getpid()) # will only log PID if windows

				print(" + + + + + + + + + + + + + + +")
				print("Update Interval is now: " + str(self.configuration['UpdateInterval']))
				print("Restart Interval is now: " + str(self.configuration['RestartInterval']))
				logging_rpi.log.info("SocketWorkerCB Module:::Websocket Address Updated:::Changed to: "+str(self.configuration["WebsocketURL"]))
				print(" + + + + + + + + + + + + + + +")

			#########################################
			# Send to Websocket
			#########################################
			self.wsReaderConn.send(str(data))
			print "sent!"
			res = self.wsReaderConn.recv()
			print res
			if res == "OK":
				ch.basic_ack(delivery_tag=method.delivery_tag)
				print("WEBSOCKET: {0} published ".format(data["Topic"]))
				return True

			print("Not successfully sent...")
			retries -= 1
			return self.customCallback(ch, method, properties, body, retries)
		except Exception as e:
			self.reconnectSocket("websocket")
			logging_rpi.log.error("SocketWorkerCB:::Exception Occured:::"+str(e))
			if any(err in str(e) for err in self.socketErrors):
				print("Socket-related errors : " + str(e))
			retries -= 1
			print("Retries left: " + str(retries) + "\n=============" + data['Topic'])
			return self.customCallback(ch, method, properties, body, retries)

	def main(self):
			self.connection = pika.BlockingConnection(pika.ConnectionParameters(host='localhost'))
			self.channel = self.connection.channel()
			self.channel.queue_declare(queue=self.publicQueue, durable=True)

			print "hello! this is main"

			def callback(ch, method, properties, body):
				if not self.customCallback(ch, method, properties, body, 3):
					#Sleeps the script if the data is unable to be sent
					logging_rpi.log.error("SocketWorkerCB:::Publishing Failed:::Exhausted Retry Attempts. Sleeping socketCB for 60 seconds.")
					time.sleep(60)
					ch.basic_reject(delivery_tag=method.delivery_tag, requeue=True)
					raise Exception("Restart Script")
			
			self.channel.basic_qos(prefetch_count=1)
			self.channel.basic_consume(queue=self.publicQueue, on_message_callback=callback)

			# After set up, actually start running the consuming

			print("----------------------------------- ccb -----------------------------------")
			print(' [*] Waiting for messages. To exit press CTRL+C')
			self.channel.start_consuming()

if __name__== "__main__":

	# Runs forever
	while True:
		try:
			BackhaulConfiguration.logProcess(os.getpid())
			configuration = BackhaulConfiguration.getDeviceConfig()
			swcb = SocketWorkerCB(configuration)
			swcb.main()
		except KeyboardInterrupt as e:
			exit()
		except Exception as e:
			print(e)
			if str(e) == "cannot concatenate 'str' and 'int' objects":
				logging_rpi.log.error("SocketWorkerCB:::Fatal Error::: Invalid Pulsar Address | Sleeping for {0} seconds before resuming operation.".format(configuration["RestartInterval"]))
			elif str(e) in [ "NotEnabled", "Restart Script"]:
				print("Websocket Not Enabled")
				pass
			else:
				logging_rpi.log.error("SocketWorkerCB:::Fatal Error::: Unexpected Error | {0} | Sleeping for {1} seconds before resuming operation.".format(str(e), configuration["RestartInterval"]))
			time.sleep(configuration["RestartInterval"])
			pass


